
## run and test

train models by
```
bash run.sh
```
test models by
```
bash run.sh
```

Those two sheel files have same parameters:
snr=30 # [30,inf]
con_num=5.0 # [5.0,50]
rho=0.05
sam_train=True

outputs are in res/

cp: LISTA-CP
cp_sam: SALISTA-CP

ana: LISTA-ANA (ALISTA)
ana_sam: SALISTA-ANA

cpss: LISTA-CPSS
cpss_sam: SALISTA-CPSS

## for single model

```shell
python3 main.py --task_type sc -g 0    --M 250 --N 500 --pnz 0.1 --SNR $snr --con_num $con_num --column_normalized True  --net $model_name -T 16 -p 1.2 -maxp 13   --scope $model_name --exp_id 0 --beta $beta --rho $rho -ts $sam_train $test_flag
```

We have fixed some parameters: 

| field     | value | help                                                         |
| --------- | ----- | ------------------------------------------------------------ |
| task_type | sc    | original project has more than one task, however we only use sparse coding here |
| g | 0    | use the `cuda:0` as default device |
| M | 250    | $A\in \mathbb{R}^{M\times N}$ |
| N | 500    | $A\in \mathbb{R}^{M\times N}$ |
| pnz | 0.1    | sparse rate |
| column_normalized | True  | do column normalized operation or not |
| T | 16    | number of layers |
|exp\_id| 0 | for mulit-run, different expid can be saved to different files, otherwise load from exist file | 

We have modifiable some parameters: 

| field         | value            | help                                    |
| ------------- | ---------------- | --------------------------------------- |
| SNR           | inf              | noise level, float(>0) or inf           |
| con_num       | 0                | condition number of measurement matrix. |
| net and scope | $model_name      | model name                              |
| rho           | [0.05,0.01,0.01] | $\rho$                                  |
| beta          | [0,1]            | $\beta$                                 |
| ts            | [True, False]    | train $\rho$ and $\beta$ or not         |
| test_flag     | [-t,]            | empty for train, -t for test            |
|               |                  |                                         |

### list of models

#### original

LISTA_cp

LISTA_cpss

ALISTA

#### SALISTA (Unified SAM)

SALISTA_cp 

SALISTA_cpss

SALISTA_ana

#### LISTA + SAM (in appendix)

SAM_LISTA_cp

USAM_LISTA_cp

#### SALISTA + ASAM (in appendix)

ASALISTA_cp

## create prob file

train models by

```bash
python3 utils/prob.py --con_num $con_num --SNR $snr --load_A data/A.npy
```

